/*
 * Decompiled with CFR 0.152.
 */
package com.racersystems.racer;

import com.racersystems.racer.AxiomLoadingStrategy;
import com.racersystems.racer.Configuration;
import com.racersystems.racer.ParseException;
import com.racersystems.racer.Racer;
import com.racersystems.racer.RacerOWLParser;
import com.racersystems.racer.RacerRuntimeException;
import com.racersystems.racer.ReasonerConfiguration;
import com.racersystems.racer.SocketAdapter;
import com.racersystems.racer.Translator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLReasonerBase;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reasoner
extends OWLReasonerBase
implements Racer {
    protected final OWLOntologyManager manager;
    protected final OWLDataFactory factory;
    protected final SocketAdapter serverAdapter;
    protected final SocketAdapter serverControlAdapter;
    protected final Translator racerTranslator;
    private boolean isUnloadOntologyBeforeReloading = false;
    protected AtomicBoolean isInterrupted = new AtomicBoolean(false);
    private Timer timer = new Timer();
    private boolean isAxiomsLoaded = false;
    Thread controlThread;
    ControlPortTask controlPortTask;
    private Logger logger = Logger.getLogger(Reasoner.class.getName());

    private void startReasonerTask(String string) {
        if (this.controlThread != null) {
            this.controlPortTask.stop();
        }
        this.controlThread = new Thread(this.controlPortTask);
        this.controlPortTask.start();
        this.controlThread.start();
        this.getReasonerConfiguration().getProgressMonitor().reasonerTaskStarted(string);
    }

    private void setProgressRange(int n, int n2) {
        PrintWriter printWriter = (PrintWriter)this.serverAdapter.getOutputWriter();
        BufferedReader bufferedReader = new BufferedReader(this.serverAdapter.getInputReader());
        String string = "(OWLAPI-setProgressRange " + n + " " + "0" + " " + n2 + " " + this.racerTranslator.getKnowledgeBaseName() + ")";
        printWriter.println(string);
        printWriter.flush();
        try {
            bufferedReader.readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void stopReasonerTask(String string) {
        this.controlPortTask.stop();
        this.getReasonerConfiguration().getProgressMonitor().reasonerTaskStopped();
    }

    private void cancelReasonerTask(String string) {
        this.controlPortTask.cancel();
    }

    public Reasoner(OWLOntology oWLOntology, Configuration configuration, BufferingMode bufferingMode) {
        super(oWLOntology, (OWLReasonerConfiguration)configuration.clone(), bufferingMode);
        this.manager = oWLOntology.getOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        try {
            this.serverAdapter = new SocketAdapter(configuration.getSocketAddress());
            this.serverControlAdapter = new SocketAdapter(new InetSocketAddress(this.getReasonerConfiguration().getSocketAddress().getAddress(), 8089));
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
        this.racerTranslator = this.createRacerTranslator();
        try {
            this.controlPortTask = new ControlPortTask(this.racerTranslator.getKnowledgeBaseName());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (configuration.getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_CREATION) {
            this.loadAxioms();
        }
    }

    protected Translator createRacerTranslator() {
        return new Translator(this.getOWLOntologyManager(), this.getReasonerConfiguration(), this.serverAdapter.getOutputWriter(), this.serverAdapter.getInputReader());
    }

    protected void loadAxioms() {
        if (!this.isAxiomsLoaded) {
            this.setProgressRange(this.getReasonerAxioms().size(), 90);
            this.startReasonerTask("Loading");
            this.racerTranslator.handleChanges(this.getReasonerAxioms(), Collections.<OWLAxiom>emptySet(), this.getReasonerConfiguration().getProgressMonitor());
            this.stopReasonerTask("Loading");
            this.isAxiomsLoaded = true;
        }
    }

    public String getReasonerName() {
        return "Racer";
    }

    public Version getReasonerVersion() {
        return this.racerTranslator.getRacerVersionNumber();
    }

    public Configuration getReasonerConfiguration() {
        return (Configuration)super.getReasonerConfiguration();
    }

    public final void setUnloadOntologyBeforeReloading(boolean bl) {
        this.isUnloadOntologyBeforeReloading = bl;
    }

    public final boolean isUnloadOntologyBeforeReloading() {
        return this.isUnloadOntologyBeforeReloading;
    }

    public final OWLOntologyManager getOWLOntologyManager() {
        return this.manager;
    }

    protected void handleChanges(Set<OWLAxiom> set, Set<OWLAxiom> set2) {
        if (this.getReasonerConfiguration().isMemorySavingModeEnabled()) {
            if (set2.size() > 0) {
                this.racerTranslator.disposeKnowledgeBase();
                this.racerTranslator.createKnowledgeBase();
                this.racerTranslator.handleChanges(this.getReasonerAxioms(), Collections.<OWLAxiom>emptySet());
            } else {
                this.racerTranslator.handleChanges(set, set2);
            }
        } else {
            this.racerTranslator.handleChanges(set, set2);
        }
    }

    public void dispose() {
        this.timer.cancel();
        super.dispose();
        this.racerTranslator.dispose();
        try {
            this.serverAdapter.closeConnection();
        }
        catch (Exception exception) {
            this.logger.severe(exception.toString());
            throw new OWLRuntimeException((Throwable)exception);
        }
        finally {
            try {
                this.serverControlAdapter.closeConnection();
            }
            catch (IOException iOException) {
                this.logger.severe(iOException.toString());
                throw new OWLRuntimeException((Throwable)iOException);
            }
        }
    }

    public void close() {
        this.disposeSilently();
    }

    protected void disposeSilently() {
        this.timer.cancel();
        super.dispose();
        this.racerTranslator.disposeSilently();
        try {
            this.serverAdapter.closeConnection();
        }
        catch (Exception exception) {
            this.logger.severe(exception.toString());
            throw new OWLRuntimeException((Throwable)exception);
        }
        finally {
            try {
                this.serverControlAdapter.closeConnection();
            }
            catch (IOException iOException) {
                this.logger.severe(iOException.toString());
                throw new OWLRuntimeException((Throwable)iOException);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    public void precomputeInferences(InferenceType ... inferenceTypeArray) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        boolean bl = false;
        boolean bl2 = false;
        this.isInterrupted.set(false);
        block11: for (InferenceType inferenceType : inferenceTypeArray) {
            switch (inferenceType) {
                case CLASS_HIERARCHY: {
                    bl = true;
                    continue block11;
                }
                case DATA_PROPERTY_HIERARCHY: {
                    bl = true;
                    continue block11;
                }
                case OBJECT_PROPERTY_HIERARCHY: {
                    bl = true;
                    continue block11;
                }
                case CLASS_ASSERTIONS: {
                    bl2 = true;
                    continue block11;
                }
                case DATA_PROPERTY_ASSERTIONS: {
                    bl2 = true;
                    continue block11;
                }
                case DIFFERENT_INDIVIDUALS: {
                    bl2 = true;
                    continue block11;
                }
                case DISJOINT_CLASSES: {
                    bl = true;
                    continue block11;
                }
                case OBJECT_PROPERTY_ASSERTIONS: {
                    bl2 = true;
                    continue block11;
                }
                case SAME_INDIVIDUAL: {
                    bl2 = true;
                }
            }
        }
        if (inferenceTypeArray == null || inferenceTypeArray.length == 0) {
            bl = true;
            bl2 = true;
        }
        if (!(this.isAxiomsLoaded || this.getReasonerConfiguration().getAxiomLoadingStrategy() != AxiomLoadingStrategy.LOAD_ON_QUERY && this.getReasonerConfiguration().getAxiomLoadingStrategy() != AxiomLoadingStrategy.LOAD_ON_PRECOMPUTE)) {
            this.loadAxioms();
        }
        if (bl && !this.isInterrupted.get()) {
            this.classify();
        }
        if (bl2 && !this.isInterrupted.get()) {
            this.realise();
        }
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        switch (inferenceType) {
            case CLASS_HIERARCHY: {
                return this.isClassified();
            }
            case DATA_PROPERTY_HIERARCHY: {
                return this.isClassified();
            }
            case OBJECT_PROPERTY_HIERARCHY: {
                return this.isClassified();
            }
            case CLASS_ASSERTIONS: {
                return this.isRealised();
            }
            case DATA_PROPERTY_ASSERTIONS: {
                return this.isRealised();
            }
            case DIFFERENT_INDIVIDUALS: {
                return this.isRealised();
            }
            case DISJOINT_CLASSES: {
                return this.isClassified();
            }
            case OBJECT_PROPERTY_ASSERTIONS: {
                return this.isRealised();
            }
            case SAME_INDIVIDUAL: {
                return this.isRealised();
            }
        }
        return false;
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return CollectionFactory.createSet((Object[])new InferenceType[]{InferenceType.CLASS_HIERARCHY, InferenceType.OBJECT_PROPERTY_HIERARCHY, InferenceType.DATA_PROPERTY_HIERARCHY, InferenceType.CLASS_ASSERTIONS, InferenceType.DATA_PROPERTY_ASSERTIONS, InferenceType.OBJECT_PROPERTY_ASSERTIONS, InferenceType.SAME_INDIVIDUAL, InferenceType.DIFFERENT_INDIVIDUALS, InferenceType.DISJOINT_CLASSES});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classify() {
        if (!(this.isAxiomsLoaded || this.getReasonerConfiguration().getAxiomLoadingStrategy() != AxiomLoadingStrategy.LOAD_ON_QUERY && this.getReasonerConfiguration().getAxiomLoadingStrategy() != AxiomLoadingStrategy.LOAD_ON_PRECOMPUTE)) {
            this.loadAxioms();
        }
        this.startReasonerTask("Classifying");
        try {
            this.racerTranslator.classify();
        }
        finally {
            this.stopReasonerTask("Classifying");
        }
    }

    public boolean isRealised() {
        return this.racerTranslator.isRealised();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void realise() {
        if (!(this.isAxiomsLoaded || this.getReasonerConfiguration().getAxiomLoadingStrategy() != AxiomLoadingStrategy.LOAD_ON_QUERY && this.getReasonerConfiguration().getAxiomLoadingStrategy() != AxiomLoadingStrategy.LOAD_ON_PRECOMPUTE)) {
            this.loadAxioms();
        }
        this.startReasonerTask("Realizing");
        try {
            this.racerTranslator.realise();
        }
        finally {
            this.stopReasonerTask("Realizing");
        }
    }

    public boolean isDefined(OWLClass oWLClass) {
        return this.racerTranslator.isDefined(oWLClass);
    }

    public boolean isDefined(OWLObjectProperty oWLObjectProperty) {
        return this.racerTranslator.isDefined(oWLObjectProperty);
    }

    public boolean isDefined(OWLDataProperty oWLDataProperty) {
        return this.racerTranslator.isDefined(oWLDataProperty);
    }

    public boolean isDefined(OWLNamedIndividual oWLNamedIndividual) {
        return this.racerTranslator.isDefined(oWLNamedIndividual);
    }

    public boolean isClassified() {
        return this.racerTranslator.isClassified();
    }

    public boolean isSatisfiable(OWLClassExpression oWLClassExpression) {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.isConsistent(oWLClassExpression);
    }

    public boolean isEntailed(Set<? extends OWLAxiom> set) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.isEntailed(set);
    }

    public boolean isEntailed(OWLAxiom oWLAxiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.isEntailed(oWLAxiom);
    }

    public void interrupt() {
        this.isInterrupted.set(true);
        this.racerTranslator.interrupt();
        this.cancelReasonerTask("");
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return this.racerTranslator.isEntailmentCheckingSupported(axiomType);
    }

    public Node<OWLClass> getTopClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)this.factory.getOWLThing());
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)this.factory.getOWLNothing());
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        return this.getEquivalentDataProperties(this.factory.getOWLTopDataProperty());
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        return this.getEquivalentDataProperties(this.factory.getOWLBottomDataProperty());
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)this.factory.getOWLTopObjectProperty());
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)this.factory.getOWLBottomObjectProperty());
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression oWLClassExpression, boolean bl) {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getSubClasses(oWLClassExpression, bl);
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression oWLClassExpression, boolean bl) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getSuperClasses(oWLClassExpression, bl);
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression oWLClassExpression) {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getEquivalentClasses(oWLClassExpression);
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getInconsistentClasses();
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression oWLClassExpression) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getDisjointClasses(oWLClassExpression);
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getSuperObjectProperties(oWLObjectPropertyExpression, bl);
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getSubObjectProperties(oWLObjectPropertyExpression, bl);
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getEquivalentObjectProperties(oWLObjectPropertyExpression);
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getObjectPropertyDomains(oWLObjectPropertyExpression, bl);
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getObjectPropertyRanges(oWLObjectPropertyExpression, bl);
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getInverseObjectProperties(oWLObjectPropertyExpression);
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty oWLDataProperty, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getSuperDataProperties(oWLDataProperty, bl);
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty oWLDataProperty, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getSubDataProperties(oWLDataProperty, bl);
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getDisjointObjectProperties(oWLObjectPropertyExpression);
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression oWLDataPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getDisjointDataProperties(oWLDataPropertyExpression);
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty oWLDataProperty) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getEquivalentProperties(oWLDataProperty);
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty oWLDataProperty, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return new OWLClassNodeSet();
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual oWLNamedIndividual, OWLDataProperty oWLDataProperty) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Map<OWLDataProperty, Set<OWLLiteral>> map;
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        if ((map = this.racerTranslator.getDataPropertyRelationships(oWLNamedIndividual)).containsKey(oWLDataProperty)) {
            return map.get(oWLDataProperty);
        }
        return Collections.emptySet();
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual oWLNamedIndividual, OWLObjectPropertyExpression oWLObjectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getObjectPropertyValues(oWLNamedIndividual, oWLObjectPropertyExpression);
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression oWLClassExpression, boolean bl) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getIndividuals(oWLClassExpression, bl);
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual oWLNamedIndividual, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getTypes(oWLNamedIndividual, bl);
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual oWLNamedIndividual) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getSameIndividuals(oWLNamedIndividual);
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual oWLNamedIndividual) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isAxiomsLoaded && this.getReasonerConfiguration().getAxiomLoadingStrategy() == AxiomLoadingStrategy.LOAD_ON_QUERY) {
            this.loadAxioms();
        }
        return this.racerTranslator.getDifferentIndividuals(oWLNamedIndividual);
    }

    public void shutdown() {
        this.racerTranslator.shutdown();
    }

    @Override
    public String getKnowledgeBaseName() {
        return this.racerTranslator.getKnowledgeBaseName();
    }

    @Override
    public String sendNativeCommand(String string, boolean bl) {
        return this.racerTranslator.sendNativeCommand(string, bl);
    }

    @Override
    public boolean isConsistent() {
        return this.racerTranslator.isConsistent();
    }

    public void setRangeDescription(boolean bl) {
        this.racerTranslator.setRangeDescriptions(bl);
    }

    public OWLEntity getCurrentEntity() {
        return this.manager.getOWLDataFactory().getOWLThing();
    }

    public static OWLReasoner createReasoner(OWLOntology oWLOntology) {
        return new ReasonerFactory().createReasoner(oWLOntology);
    }

    public static OWLReasoner createReasoner(OWLOntology oWLOntology, OWLReasonerConfiguration oWLReasonerConfiguration) {
        return new ReasonerFactory().createReasoner(oWLOntology, oWLReasonerConfiguration);
    }

    public static OWLReasoner createNonBufferingReasoner(OWLOntology oWLOntology) {
        return new ReasonerFactory().createNonBufferingReasoner(oWLOntology);
    }

    public static OWLReasoner CreateNonBufferingReasoner(OWLOntology oWLOntology, OWLReasonerConfiguration oWLReasonerConfiguration) {
        return new ReasonerFactory().createNonBufferingReasoner(oWLOntology, oWLReasonerConfiguration);
    }

    public static class ReasonerFactory
    implements OWLReasonerFactory {
        private static final String reasonerName = "Racer";

        public final String getReasonerName() {
            return reasonerName;
        }

        protected Configuration getConfiguration(OWLReasonerConfiguration oWLReasonerConfiguration) {
            if (oWLReasonerConfiguration instanceof Configuration) {
                return (Configuration)oWLReasonerConfiguration;
            }
            return new Configuration(oWLReasonerConfiguration);
        }

        public OWLReasoner createNonBufferingReasoner(OWLOntology oWLOntology) {
            return new Reasoner(oWLOntology, new Configuration(), BufferingMode.NON_BUFFERING);
        }

        public OWLReasoner createReasoner(OWLOntology oWLOntology) {
            return new Reasoner(oWLOntology, new Configuration(), BufferingMode.BUFFERING);
        }

        public OWLReasoner createNonBufferingReasoner(OWLOntology oWLOntology, OWLReasonerConfiguration oWLReasonerConfiguration) throws IllegalConfigurationException {
            return new Reasoner(oWLOntology, this.getConfiguration(oWLReasonerConfiguration), BufferingMode.NON_BUFFERING);
        }

        public OWLReasoner createReasoner(OWLOntology oWLOntology, OWLReasonerConfiguration oWLReasonerConfiguration) throws IllegalConfigurationException {
            return new Reasoner(oWLOntology, this.getConfiguration(oWLReasonerConfiguration), BufferingMode.BUFFERING);
        }
    }

    public class RacerClient {
        private int socket;
        private String host = null;
        private boolean printWarningMessages = true;
        private boolean debugging = false;
        private boolean useStringBuildersEvenForTokens = false;
        private boolean globallyEnableSimplifiedProtocol = true;
        private String lastWarning = "";
        private Socket racerSocket = null;
        public PrintWriter out = null;
        public BufferedReader in = null;
        private Map<String, Object[]> withMacroStack = new LinkedHashMap<String, Object[]>();

        public RacerClient(String string, int n) {
            this.host = string;
            this.socket = n;
        }

        public void openConnection() throws RuntimeException {
            try {
                this.racerSocket = new Socket(this.host, this.socket);
                this.racerSocket.setReuseAddress(true);
                this.out = new PrintWriter(new OutputStreamWriter(this.racerSocket.getOutputStream(), "UTF-8"));
                this.in = new BufferedReader(new InputStreamReader(this.racerSocket.getInputStream(), "UTF-8"));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }

        public void closeConnection() {
            try {
                this.out.close();
                this.in.close();
                this.racerSocket.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
        }

        public String sendRaw(String string) {
            try {
                this.out.println(string);
                this.out.flush();
                String string2 = this.parse(this.in.readLine());
                return string2;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }

        private String parse(String string) {
            return string;
        }

        private String simpleParse(String string) throws RuntimeException {
            return string;
        }
    }

    static class MonitorTask3 {
        String reasonerID;
        ReasonerProgressMonitor monitor;
        SocketAdapter adapter;
        PrintWriter writer;
        BufferedReader inputStreamReader;
        Timer timer;
        TimerTask task;
        RacerOWLParser parser;
        volatile boolean isRunning;
        volatile boolean isCanceled;
        final int delay = 100;

        public MonitorTask3(OWLOntologyManager oWLOntologyManager, ReasonerConfiguration reasonerConfiguration, String string) {
            InetSocketAddress inetSocketAddress = reasonerConfiguration.getSocketAddress();
            this.monitor = reasonerConfiguration.getProgressMonitor();
            this.reasonerID = string;
            try {
                this.adapter = new SocketAdapter(inetSocketAddress);
                this.writer = new PrintWriter(new BufferedWriter(this.adapter.getOutputWriter()));
                this.inputStreamReader = new BufferedReader(new InputStreamReader(this.adapter.getInputStream(), "UTF-8"));
                this.parser = new RacerOWLParser(this.adapter.getInputStream(), "UTF-8");
                this.parser.setUp(oWLOntologyManager.getOWLDataFactory());
                this.writer.print("(");
                this.writer.print("OWLAPI-progressCertain?");
                this.writer.print(" ");
                this.writer.print(string);
                this.writer.println(")");
                this.inputStreamReader.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.timer = new Timer();
        }

        public void start(String string) {
            if (this.isRunning) {
                this.stop();
            }
            this.task = new TimerTask(){

                public void run() {
                    try {
                        MonitorTask3.this.run();
                    }
                    catch (ParseException parseException) {
                        parseException.printStackTrace();
                    }
                }
            };
            this.monitor.reasonerTaskStarted(string);
            this.isRunning = true;
            this.timer.schedule(this.task, 100L, 10L);
        }

        public void cancel() {
            this.isCanceled = true;
            this.stop();
        }

        public void stop() {
            if (this.isRunning) {
                this.timer.cancel();
                this.monitor.reasonerTaskStopped();
                this.isRunning = false;
            }
            this.isCanceled = false;
        }

        public void run() throws ParseException {
            boolean bl = false;
            this.writer.print("(");
            this.writer.print("OWLAPI-progressCertain?");
            this.writer.print(" ");
            this.writer.print(this.reasonerID);
            this.writer.println(")");
            try {
                this.inputStreamReader.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            bl = this.parser.BooleanResult();
            if (!bl) {
                this.monitor.reasonerTaskBusy();
            } else {
                this.writer.print("(");
                this.writer.print("OWLAPI-getProgress");
                this.writer.print(" ");
                this.writer.print(this.reasonerID);
                this.writer.println(")");
                int n = this.parser.parseIntegerResult();
            }
            while (this.isRunning) {
                if (this.isCanceled) {
                    this.writer.print("(");
                    this.writer.print("OWLAPI-abortRequest");
                    this.writer.print(" ");
                    this.writer.print(this.reasonerID);
                    this.writer.println(")");
                    try {
                        this.inputStreamReader.readLine();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                this.writer.print("(");
                this.writer.print("OWLAPI-progressCertain?");
                this.writer.print(" ");
                this.writer.print(this.reasonerID);
                this.writer.println(this.reasonerID);
                this.writer.println(")");
                if (bl) {
                    this.writer.print("(");
                    this.writer.print("OWLAPI-getProgress");
                    this.writer.println(this.reasonerID);
                    this.writer.println(")");
                    int n = this.parser.parseIntegerResult();
                    this.monitor.reasonerTaskProgressChanged(n, 100);
                    continue;
                }
                this.monitor.reasonerTaskBusy();
            }
        }
    }

    @Deprecated
    class ProgressMonitorTask
    extends TimerTask {
        PrintWriter out;
        BufferedReader reader;
        String reasonerID;
        boolean isCanceled;
        String task;

        public ProgressMonitorTask(String string, ReasonerConfiguration reasonerConfiguration, String string2) throws IOException {
            this.reasonerID = string2;
            this.out = (PrintWriter)Reasoner.this.serverControlAdapter.getOutputWriter();
            this.reader = new BufferedReader(Reasoner.this.serverControlAdapter.getInputReader());
            this.task = string;
        }

        public void run() {
            try {
                this.out.println("(OWLAPI-progressCertain? " + this.reasonerID + ")");
                this.out.flush();
                if (this.reader.readLine().equals("t")) {
                    this.out.print("(");
                    this.out.print("OWLAPI-getProgress");
                    this.out.print(" ");
                    this.out.print(this.reasonerID);
                    this.out.println(")");
                    this.out.flush();
                    String string = this.reader.readLine();
                    Reasoner.this.getReasonerConfiguration().getProgressMonitor().reasonerTaskProgressChanged(Integer.parseInt(string), 100);
                } else {
                    Reasoner.this.getReasonerConfiguration().getProgressMonitor().reasonerTaskBusy();
                }
            }
            catch (IOException iOException) {
                System.out.println("run exception " + this.task + iOException.getMessage());
            }
        }

        public void start(String string) {
            Reasoner.this.getReasonerConfiguration().getProgressMonitor().reasonerTaskStarted(string);
        }

        public boolean cancel() {
            this.isCanceled = true;
            this.out.print("(");
            this.out.print("OWLAPI-abortRequest");
            this.out.print(" ");
            this.out.print(this.reasonerID);
            this.out.println(")");
            try {
                String string = this.reader.readLine();
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return super.cancel();
        }

        public void stop(String string) {
            Reasoner.this.getReasonerConfiguration().getProgressMonitor().reasonerTaskStopped();
        }
    }

    class ControlPortTask
    implements Runnable {
        PrintWriter pw;
        BufferedReader reader;
        String reasonerID;
        AtomicBoolean isCancelled = new AtomicBoolean(false);
        AtomicBoolean isRunning = new AtomicBoolean(false);

        public ControlPortTask(String string) throws IOException {
            this.reasonerID = string;
            this.pw = (PrintWriter)Reasoner.this.serverControlAdapter.getOutputWriter();
            this.reader = new BufferedReader(Reasoner.this.serverControlAdapter.getInputReader());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.isRunning.get()) {
                try {
                    PrintWriter printWriter = this.pw;
                    synchronized (printWriter) {
                        String string;
                        if (this.isCancelled.get()) {
                            this.pw.print("(");
                            this.pw.print("OWLAPI-abortRequest");
                            this.pw.print(" ");
                            this.pw.print(this.reasonerID);
                            this.pw.println(")");
                            try {
                                string = this.reader.readLine();
                                this.pw.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.isRunning.set(false);
                            return;
                        }
                        this.pw.print("(");
                        this.pw.print("OWLAPI-progressCertain?");
                        this.pw.print(' ');
                        this.pw.print(this.reasonerID);
                        this.pw.println(")");
                        this.pw.flush();
                        string = this.reader.readLine();
                        if ("t".equals(string)) {
                            this.pw.print("(");
                            this.pw.print("OWLAPI-getProgress");
                            this.pw.print(" ");
                            this.pw.print(this.reasonerID);
                            this.pw.println(")");
                            this.pw.flush();
                            String string2 = this.reader.readLine();
                            if (this.isRunning.get()) {
                                Reasoner.this.getReasonerConfiguration().getProgressMonitor().reasonerTaskProgressChanged(Integer.parseInt(string2), 100);
                            }
                        } else if (this.isRunning.get()) {
                            Reasoner.this.getReasonerConfiguration().getProgressMonitor().reasonerTaskBusy();
                        }
                    }
                    if (!this.isRunning.get()) continue;
                    Thread.currentThread();
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            PrintWriter printWriter = this.pw;
            synchronized (printWriter) {
                this.isRunning.set(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            PrintWriter printWriter = this.pw;
            synchronized (printWriter) {
                this.isRunning.set(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            PrintWriter printWriter = this.pw;
            synchronized (printWriter) {
                this.isCancelled.set(true);
            }
        }
    }
}

