/*
 * Decompiled with CFR 0.152.
 */
package com.racersystems.racer;

import com.racersystems.racer.RacerRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public final class SocketAdapter {
    private final Socket racerSocket;
    private final InputStream racerInputStream;
    private final Writer racerOutputStream;
    private Reader inputStreamReader;
    private boolean isClosed = false;
    private static final String SERVER_END_STRING = ":eof";

    public SocketAdapter(InetSocketAddress inetSocketAddress) throws IOException {
        this.racerSocket = new Socket(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        this.racerSocket.setReuseAddress(true);
        this.racerSocket.setSendBufferSize(64000);
        this.racerInputStream = this.racerSocket.getInputStream();
        this.racerOutputStream = new PrintWriter(new OutputStreamWriter(this.racerSocket.getOutputStream(), "UTF-8"));
        this.inputStreamReader = new InputStreamReader(this.racerSocket.getInputStream(), "UTF-8");
    }

    public void closeConnection() throws IOException {
        if (this.racerSocket.isConnected() && !this.isClosed) {
            this.racerOutputStream.write(":eof\n");
        }
        this.racerOutputStream.flush();
        this.racerInputStream.close();
        this.racerOutputStream.close();
        this.racerSocket.close();
        this.isClosed = true;
    }

    public final Writer getOutputWriter() {
        return this.racerOutputStream;
    }

    public final InputStream getInputStream() {
        return this.racerInputStream;
    }

    public final Reader getInputReader() {
        return this.inputStreamReader;
    }

    public final InetAddress getInetAddress() {
        return this.racerSocket.getInetAddress();
    }

    private static String readFromSocket(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        try {
            n = inputStream.read();
            byteArrayOutputStream.write(n);
            while (n != 10) {
                n = inputStream.read();
                if (n == 10) continue;
                byteArrayOutputStream.write(n);
            }
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
        String string = byteArrayOutputStream.toString();
        return string;
    }
}

