/*
 * Decompiled with CFR 0.152.
 */
package com.racersystems.racer;

import com.racersystems.racer.Configuration;
import com.racersystems.racer.DescriptionRenderer;
import com.racersystems.racer.NotSupportedRacerException;
import com.racersystems.racer.ParseException;
import com.racersystems.racer.RacerOWLParser;
import com.racersystems.racer.RacerRuntimeException;
import com.racersystems.racer.util.RacerBufferedWriter;
import com.racersystems.racer.util.RacerPrefixManager;
import com.racersystems.racer.util.RacerShortFormProvider;
import com.racersystems.racer.util.ShortFormProvider;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;
import org.semanticweb.owlapi.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Translator
extends OWLAxiomVisitorAdapter
implements OWLOntologyChangeVisitor {
    protected PrintWriter writer;
    protected final Reader inputStream;
    protected DescriptionRenderer renderer;
    protected NamedObjectForAnnotationRenderer noaRenderer;
    protected RacerOWLParser resultParser;
    protected OWLOntologyManager owlOntologyManager;
    protected String reasonerID;
    protected String ontologyID;
    protected Set<OWLClass> definedClasses;
    protected boolean isAdd = true;
    private boolean autoBatchSynchronizeNeeded = false;
    private Configuration configuration;
    public StringBuffer buffer = new StringBuffer();
    private boolean rangeDescriptions = false;
    private boolean isSimplifiedRacerDispose = false;
    boolean isInterrupted = false;
    SingleCommand commandVisitor;
    RacerPrefixManager prefixManager = new RacerPrefixManager();
    RacerBufferedWriter bufferedWriter;
    PrintWriter directWriter;
    EntailmentChecker entailmentChecker = new EntailmentChecker();

    public Translator(OWLOntologyManager oWLOntologyManager, Configuration configuration, Writer writer, Reader reader) {
        this.owlOntologyManager = oWLOntologyManager;
        this.configuration = configuration;
        this.bufferedWriter = new RacerBufferedWriter(writer);
        this.writer = new PrintWriter(this.bufferedWriter);
        this.directWriter = new PrintWriter(new BufferedWriter(writer));
        this.inputStream = reader;
        this.renderer = this.createDefaultRacerDescriptionRenderer();
        this.noaRenderer = new NamedObjectForAnnotationRenderer(this.writer, this.renderer.getShortFormProvider());
        this.resultParser = this.createDefaultRacerParser();
        this.definedClasses = CollectionFactory.createSet();
        Version version = this.getRacerVersionNumber();
        Version version2 = new Version(2, 0, 0, 20101025);
        if (version.getMajor() < version2.getMajor() && version.getMinor() <= version2.getMinor() && version.getBuild() <= version2.getBuild()) {
            throw new NotSupportedRacerException(version);
        }
        if (!this.isOWLAPIInit()) {
            try {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-init");
                this.writeCloseParln();
                String string = this.readFromSocket();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.createKnowledgeBase();
        this.commandVisitor = new SingleCommand();
    }

    protected void interrupt() {
        this.isInterrupted = true;
    }

    public void setSimplifiedRacerDispose(boolean bl) {
        this.isSimplifiedRacerDispose = bl;
    }

    public boolean isOWLAPIInit() {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("all-tboxes");
            this.writeCloseParln();
            String string = this.readFromSocket();
            string = string.replace("(", "");
            string = string.replace(")", "");
            string = string.replace("\"", "");
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!string2.equals("OWLAPI-KB")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String getKnowledgeBaseName() {
        return this.reasonerID;
    }

    protected RacerOWLParser createDefaultRacerParser() {
        RacerOWLParser racerOWLParser = new RacerOWLParser(this.inputStream);
        racerOWLParser.setUp(this.owlOntologyManager.getOWLDataFactory());
        return racerOWLParser;
    }

    protected DescriptionRenderer createDefaultRacerDescriptionRenderer() {
        return new DescriptionRenderer(this.prefixManager, this.writer, new RacerShortFormProvider(this.owlOntologyManager.getOWLDataFactory()));
    }

    public final DescriptionRenderer getDescriptionRenderer() {
        return this.renderer;
    }

    public final void visit(AddAxiom addAxiom) {
    }

    public final void visit(RemoveAxiom removeAxiom) {
    }

    public void visit(SetOntologyID setOntologyID) {
    }

    public void visit(AddImport addImport) {
    }

    public void visit(RemoveImport removeImport) {
    }

    public void visit(AddOntologyAnnotation addOntologyAnnotation) {
    }

    public void visit(RemoveOntologyAnnotation removeOntologyAnnotation) {
    }

    public final void createKnowledgeBase() {
        if (this.reasonerID != null) {
            this.disposeOWLReasoner();
        }
        try {
            int n;
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-newReasoner");
            this.writeSpace();
            this.writeKRSSMethodName(":create");
            this.writeCloseParln();
            String string = this.resultParser.readNativeLine();
            if (string.startsWith(":answer") && (n = (string = string.replace(":answer", "")).indexOf("\"")) > -1) {
                int n2 = string.lastIndexOf("\"");
                if (n2 <= n) {
                    n2 = string.length();
                }
                string = string.substring(n, n2);
            }
            string = string.replace("\"", "");
            string = string.replace("\\", "");
            this.ontologyID = this.reasonerID = (string = string.replace(" ", ""));
            this.enableSimplifiedProtocol();
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-newOntology");
            this.writeS(this.ontologyID);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            this.resultParser.parseOWLStringAnswer();
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-loadOntology");
            this.writeS(this.ontologyID);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            this.resultParser.parseOWLAnswer();
            if (this.configuration.isMemorySavingModeEnabled()) {
                this.enableMemorySavingMode();
            }
        }
        catch (Exception exception) {
            this.reasonerID = null;
            throw new RacerRuntimeException(exception);
        }
    }

    protected void enableMemorySavingMode() {
        this.writeOpenPar();
        this.writeKRSSMethodName("OWLAPI-enableMemorySavingMode");
        this.writeS(this.ontologyID);
        this.writeS(this.reasonerID);
        this.writeCloseParln();
        String string = this.readFromSocket();
    }

    public void disposeKnowledgeBase() {
        try {
            if (this.ontologyID != null && !this.isSimplifiedRacerDispose) {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-unloadOntology");
                this.writeS(this.ontologyID);
                this.writeCloseParln();
                this.ontologyID = null;
                this.resultParser.parseOWLAnswer();
            }
            if (this.reasonerID != null) {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-disposeReasoner");
                this.writeS(this.reasonerID);
                this.writeCloseParln();
                this.reasonerID = null;
                this.resultParser.readNativeLine();
            }
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void disposeSilently() {
        this.ontologyID = null;
        this.reasonerID = null;
    }

    @Deprecated
    public final void createOWLReasoner() {
        if (this.reasonerID != null) {
            this.disposeOWLReasoner();
        }
        try {
            this.reasonerID = "OWLAPIReasoner" + String.valueOf(System.currentTimeMillis());
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-newReasoner");
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            this.readFromSocket();
            this.enableSimplifiedProtocol();
        }
        catch (Exception exception) {
            this.reasonerID = null;
            throw new RacerRuntimeException(exception);
        }
    }

    public void disposeOWLReasoner() {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-disposeReasoner");
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            this.resultParser.parseOWLAnswer();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public final void enableSimplifiedProtocol() {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-enableSimplifiedProtocol");
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            String string = this.resultParser.readNativeLine();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public final void autoApplyChanges() {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-autoApplyChanges");
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            this.resultParser.readNativeLine();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    protected final void setAxiomID() {
        this.writeOpenPar();
        this.writeKRSSMethodName("OWLAPI-setAxiomCounter");
        this.writeS(0);
        this.writeClosePar();
    }

    protected final void autoBatchRemoveAxioms() {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-autoBatchRemoveAxiomsFrom");
            this.writeS(this.ontologyID);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            this.resultParser.readNativeLine();
            this.isAdd = false;
            this.autoBatchSynchronizeNeeded = true;
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    protected final void autoBatchAddAxioms() {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-autoBatchAddAxiomsTo");
            this.writeS(this.ontologyID);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            this.resultParser.readNativeLine();
            this.isAdd = false;
            this.autoBatchSynchronizeNeeded = true;
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    protected final void batchSynchronize() {
        if (!this.autoBatchSynchronizeNeeded) {
            return;
        }
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-batchSynchronize");
            this.writeS(this.ontologyID);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            String string = this.resultParser.readNativeLine();
            this.isAdd = !this.isAdd;
            this.autoBatchSynchronizeNeeded = false;
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    protected final void autoRemoveAxioms(String string, boolean bl) {
        if (bl) {
            this.autoRemoveAxioms(string, false);
        } else {
            try {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-autoRemoveAxiomsFrom");
                this.writeS(string);
                this.writeS(this.reasonerID);
                this.writeCloseParln();
                this.resultParser.readNativeLine();
                this.isAdd = false;
            }
            catch (Exception exception) {
                throw new RacerRuntimeException(exception);
            }
        }
    }

    public final void autoAddAxioms(String string) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-autoAddAxiomsTo");
            this.writeS(string);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            this.resultParser.readNativeLine();
            this.isAdd = true;
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public final void autoAddAxioms(OWLOntology oWLOntology) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-autoAddAxiomsTo");
            this.writeS(oWLOntology.getOntologyID().getOntologyIRI());
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            this.resultParser.readNativeLine();
            this.isAdd = true;
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public Version getRacerVersionNumber() {
        String string = "";
        try {
            int n;
            int n2;
            int n3;
            this.writeOpenPar();
            this.writeKRSSMethodName("get-racer-version");
            this.writeCloseParln();
            string = this.readFromSocket();
            if (string.startsWith(":answer") && (n3 = (string = string.replace(":answer", "")).indexOf("\"")) > -1) {
                n2 = string.lastIndexOf("\"");
                if (n2 <= n3) {
                    n2 = string.length();
                }
                string = string.substring(n3, n2);
            }
            string = string.replace("\"", "");
            string = string.replace("\\", "");
            string = string.replace(" ", "");
            n3 = 0;
            n2 = 0;
            int n4 = 0;
            int n5 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (stringTokenizer.hasMoreTokens()) {
                n3 = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                n5 = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                n4 = Integer.parseInt(stringTokenizer.nextToken());
            }
            this.writeOpenPar();
            this.writeKRSSMethodName("get-build-version");
            this.writeCloseParln();
            string = this.resultParser.readNativeLine();
            if (string.startsWith(":answer") && (n = (string = string.replace(":answer", "")).indexOf("\"")) > -1) {
                int n6 = string.lastIndexOf("\"");
                if (n6 <= n) {
                    n6 = string.length();
                }
                string = string.substring(n, n6);
            }
            string = string.replace("\"", "");
            string = string.replace("\\", "");
            string = string.replace(" ", "");
            n5 = Integer.parseInt(string.replace("-", ""));
            return new Version(n3, n2, n4, n5);
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void writeSequenceProlog() {
        this.writeOpenPar();
        this.writeKRSSMethodName("owlapi-sequence");
        this.writeS(this.reasonerID);
    }

    public void writeSequenceEpilog() {
        this.writeCloseParln();
        try {
            this.resultParser.parseOWLAnswer();
        }
        catch (ParseException parseException) {
            throw new RacerRuntimeException(parseException);
        }
        catch (InconsistentOntologyException inconsistentOntologyException) {
            // empty catch block
        }
    }

    public final void writeProlog() {
        this.writeOpenPar();
    }

    public final void writeEpilog() {
        this.writer.println();
        this.writer.flush();
        try {
            this.resultParser.parseOWLAnswer();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
    }

    protected final void writeOpenPar() {
        this.writer.write("(");
    }

    protected final void writeClosePar() {
        this.writer.write(")");
    }

    protected final void writeCloseParln() {
        this.writer.println(")");
        this.writer.flush();
    }

    protected final void send() {
        this.writer.println();
        this.writer.flush();
        try {
            this.resultParser.parseOWLAnswer();
        }
        catch (ParseException parseException) {
            throw new RacerRuntimeException(parseException);
        }
        catch (InconsistentOntologyException inconsistentOntologyException) {
            // empty catch block
        }
    }

    protected final void writeKRSSMethodName(String string) {
        this.writer.write(string);
    }

    protected final void writeS(String string) {
        this.writer.write(" ");
        this.writer.write(string);
    }

    protected final void writeSpace() {
        this.writer.write(" ");
    }

    protected final void writeS(int n) {
        this.writer.write(" ");
        this.writer.write(Integer.toString(n));
    }

    protected final void writeS(IRI iRI) {
        this.writer.write(" ");
        this.writer.write("|");
        this.writer.write(iRI.toString());
        this.writer.write("|");
    }

    protected final void writeAddAxiomProlog() {
        this.writeKRSSMethodName("OWLAPI-AddAxiom");
        this.writeS(this.ontologyID);
    }

    protected final void writeRemoveAxiomProlog() {
        this.writeKRSSMethodName("OWLAPI-RemoveAxiom");
        this.writeSpace();
        this.writeS(this.ontologyID);
    }

    protected final void writeDescriptions(Set<OWLClassExpression> set) throws IOException {
        this.writeOpenPar();
        for (OWLClassExpression oWLClassExpression : set) {
            this.renderer.write(oWLClassExpression);
        }
        this.writeClosePar();
    }

    protected final void writeProperties(Set<OWLPropertyExpression> set) throws IOException {
        this.writeOpenPar();
        for (OWLPropertyExpression oWLPropertyExpression : set) {
            this.renderer.write(oWLPropertyExpression);
        }
        this.writeClosePar();
    }

    public void dispose() {
        this.disposeKnowledgeBase();
    }

    public void unloadOntologies(Set<OWLOntology> set) {
        for (OWLOntology oWLOntology : set) {
            try {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-unloadOntology");
                this.writeS(oWLOntology.getOntologyID().getOntologyIRI());
                this.writeS(this.reasonerID);
                this.writeCloseParln();
                this.resultParser.parseOWLAnswer();
            }
            catch (ParseException parseException) {
                this.reportError(parseException);
            }
            catch (Exception exception) {
                throw new RacerRuntimeException(exception.getCause());
            }
        }
    }

    public void classify() {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-classify");
            this.writeS(this.reasonerID);
            if (!this.configuration.isAboxConsistencyTestEnabled()) {
                this.writeS("nil");
            }
            this.writeCloseParln();
            this.resultParser.parseOWLAnswer();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
        }
        catch (InconsistentOntologyException inconsistentOntologyException) {
            throw new InconsistentOntologyException();
        }
    }

    public boolean isClassified() {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isClassified");
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
    }

    public boolean isRealised() {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isRealised");
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
    }

    public void realise() {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-realize");
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            this.resultParser.parseOWLAnswer();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
        }
    }

    public final boolean isDefined(OWLClass oWLClass) {
        try {
            if (oWLClass.isBuiltIn()) {
                return true;
            }
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isDefinedClass");
            oWLClass.accept((OWLNamedObjectVisitor)this.renderer);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
    }

    public final boolean isDefined(OWLObjectProperty oWLObjectProperty) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isDefinedObjectProperty");
            oWLObjectProperty.accept((OWLNamedObjectVisitor)this.renderer);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
    }

    public final boolean isDefined(OWLDataProperty oWLDataProperty) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isDefinedDataProperty");
            oWLDataProperty.accept((OWLNamedObjectVisitor)this.renderer);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
    }

    public final boolean isDefined(OWLNamedIndividual oWLNamedIndividual) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isDefinedIndividual");
            this.renderer.write(oWLNamedIndividual.asOWLNamedIndividual());
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public boolean isSubClassOf(OWLClassExpression oWLClassExpression, OWLClassExpression oWLClassExpression2) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isSubClassOf");
            oWLClassExpression.accept((OWLClassExpressionVisitor)this.renderer);
            oWLClassExpression2.accept((OWLClassExpressionVisitor)this.renderer);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression oWLClassExpression, boolean bl) {
        Set<Set<OWLClass>> set = bl ? this.getSubClasses(oWLClassExpression) : this.getDescendantClasses(oWLClassExpression);
        return this.convertToClassNodeSet(set);
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression oWLClassExpression, boolean bl) {
        Set<Set<OWLClass>> set = bl ? this.getSuperClasses(oWLClassExpression) : this.getAncestorClasses(oWLClassExpression);
        return this.convertToClassNodeSet(set);
    }

    NodeSet<OWLClass> convertToClassNodeSet(Set<Set<OWLClass>> set) {
        OWLClassNodeSet oWLClassNodeSet = new OWLClassNodeSet();
        for (Set<OWLClass> set2 : set) {
            OWLClassNode oWLClassNode = new OWLClassNode(set2);
            oWLClassNodeSet.addNode((Node)oWLClassNode);
        }
        return oWLClassNodeSet;
    }

    public Set<Set<OWLClass>> getSubClasses(OWLClassExpression oWLClassExpression) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getSubClasses");
            oWLClassExpression.accept((OWLClassExpressionVisitor)this.renderer);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseConceptSoSResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Set<Set<OWLClass>> getSuperClasses(OWLClassExpression oWLClassExpression) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getSuperClasses");
            oWLClassExpression.accept((OWLClassExpressionVisitor)this.renderer);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            Set<Set<OWLClass>> set = this.resultParser.parseConceptSoSResult();
            return set;
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression oWLClassExpression) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getEquivalentClasses");
            oWLClassExpression.accept((OWLClassExpressionVisitor)this.renderer);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseClassNodeResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
    }

    public Node<OWLClass> getInconsistentClasses() {
        return this.getEquivalentClasses((OWLClassExpression)this.owlOntologyManager.getOWLDataFactory().getOWLNothing());
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression oWLClassExpression) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getDisjointClasses");
            oWLClassExpression.accept((OWLClassExpressionVisitor)this.renderer);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseOWLClassNodeSetResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
    }

    public Set<Set<OWLClass>> getAncestorClasses(OWLClassExpression oWLClassExpression) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getAncestorClasses");
            oWLClassExpression.accept((OWLClassExpressionVisitor)this.renderer);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseConceptSoSResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
    }

    public Set<Set<OWLClass>> getDescendantClasses(OWLClassExpression oWLClassExpression) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getDescendantClasses");
            oWLClassExpression.accept((OWLClassExpressionVisitor)this.renderer);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseConceptSoSResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
    }

    public boolean isConsistent(OWLClassExpression oWLClassExpression) {
        return !this.getEquivalentClasses(oWLClassExpression).contains((OWLObject)this.owlOntologyManager.getOWLDataFactory().getOWLNothing());
    }

    public boolean isEquivalentClass(OWLClassExpression oWLClassExpression, OWLClassExpression oWLClassExpression2) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isEquivalentClass");
            oWLClassExpression.accept((OWLClassExpressionVisitor)this.renderer);
            oWLClassExpression2.accept((OWLClassExpressionVisitor)this.renderer);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
    }

    public NodeSet<OWLDataProperty> getAncestorProperties(OWLDataProperty oWLDataProperty) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getAncestorProperties");
            this.renderer.write((OWLPropertyExpression)oWLDataProperty);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseOWLDataPropertyNodeSetResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public NodeSet<OWLObjectPropertyExpression> getAncestorProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getAncestorProperties");
            this.renderer.write((OWLPropertyExpression)oWLObjectPropertyExpression);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseObjectPropertyNodeSetResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public NodeSet<OWLDataProperty> getDescendantProperties(OWLDataProperty oWLDataProperty) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getDescendantProperties");
            this.renderer.write((OWLPropertyExpression)oWLDataProperty);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseOWLDataPropertyNodeSetResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public NodeSet<OWLObjectPropertyExpression> getDescendantProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getDescendantProperties");
            this.renderer.write((OWLPropertyExpression)oWLObjectPropertyExpression);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseObjectPropertyNodeSetResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    protected NodeSet<OWLObjectPropertyExpression> convertToObjectPropertiesNodeSet(Set<Set<OWLObjectPropertyExpression>> set) {
        OWLObjectPropertyNodeSet oWLObjectPropertyNodeSet = new OWLObjectPropertyNodeSet();
        for (Set<OWLObjectPropertyExpression> set2 : set) {
            OWLObjectPropertyNode oWLObjectPropertyNode = new OWLObjectPropertyNode(set2);
            oWLObjectPropertyNodeSet.addNode((Node)oWLObjectPropertyNode);
        }
        return oWLObjectPropertyNodeSet;
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (bl) {
            return this.getSuperProperties(oWLObjectPropertyExpression);
        }
        return this.getAncestorProperties(oWLObjectPropertyExpression);
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (bl) {
            return this.getSubProperties(oWLObjectPropertyExpression);
        }
        return this.getDescendantProperties(oWLObjectPropertyExpression);
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getDomains");
            this.renderer.write((OWLPropertyExpression)oWLObjectPropertyExpression);
            this.writeS(this.reasonerID);
            this.writeS(3);
            this.writeCloseParln();
            return this.resultParser.parseOWLClassNodeSetResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public Node<OWLDataProperty> getEquivalentProperties(OWLDataProperty oWLDataProperty) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getEquivalentProperties");
            this.renderer.write((OWLPropertyExpression)oWLDataProperty);
            this.writeS(this.reasonerID);
            this.writeS("nil");
            this.writeCloseParln();
            return this.resultParser.parseOWLDataPropertyNodeResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getEquivalentProperties");
            this.renderer.write((OWLPropertyExpression)oWLObjectPropertyExpression);
            this.writeS(this.reasonerID);
            this.writeS("nil");
            this.writeCloseParln();
            return this.resultParser.parseObjectPropertyNodeResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getInverseProperties");
            this.renderer.write((OWLPropertyExpression)oWLObjectPropertyExpression.getSimplified());
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            NodeSet<OWLObjectPropertyExpression> nodeSet = this.resultParser.parseObjectPropertyNodeSetResult();
            if (nodeSet.getNodes().isEmpty()) {
                return new OWLObjectPropertyNode();
            }
            return (Node)nodeSet.getNodes().iterator().next();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public Set<OWLDatatype> getRanges(OWLDataProperty oWLDataProperty) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getRanges");
            this.renderer.write((OWLPropertyExpression)oWLDataProperty);
            this.writeS(this.reasonerID);
            this.writeS(2);
            this.writeCloseParln();
            return this.resultParser.parseDatatypeSetResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) {
        if (oWLObjectPropertyExpression.isAnonymous()) {
            throw new RacerRuntimeException("Anonymouse ObjectProperties are not supported");
        }
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getRanges");
            this.renderer.write((OWLPropertyExpression)oWLObjectPropertyExpression);
            this.writeS(this.reasonerID);
            if (!this.rangeDescriptions) {
                this.writeS(2);
                this.writeCloseParln();
                return this.resultParser.parseOWLClassNodeSetResult();
            }
            this.writeCloseParln();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
        return null;
    }

    public NodeSet<OWLDataProperty> getSubProperties(OWLDataProperty oWLDataProperty) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getSubProperties");
            this.renderer.write((OWLPropertyExpression)oWLDataProperty);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseOWLDataPropertyNodeSetResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public NodeSet<OWLObjectPropertyExpression> getSubProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getSubProperties");
            this.renderer.write((OWLPropertyExpression)oWLObjectPropertyExpression);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseObjectPropertyNodeSetResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty oWLDataProperty, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (bl) {
            return this.getSuperProperties(oWLDataProperty);
        }
        return this.getAncestorProperties(oWLDataProperty);
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty oWLDataProperty, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (bl) {
            return this.getSubProperties(oWLDataProperty);
        }
        return this.getDescendantProperties(oWLDataProperty);
    }

    public NodeSet<OWLDataProperty> getSuperProperties(OWLDataProperty oWLDataProperty) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getSuperProperties");
            this.renderer.write((OWLPropertyExpression)oWLDataProperty);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseOWLDataPropertyNodeSetResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception.getCause());
        }
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getSuperProperties");
            this.renderer.write((OWLPropertyExpression)oWLObjectPropertyExpression);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseObjectPropertyNodeSetResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getDisjointObjectProperties");
            this.renderer.write((OWLPropertyExpression)oWLObjectPropertyExpression);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseObjectPropertyNodeSetResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression oWLDataPropertyExpression) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getDisjointDataProperties");
            this.renderer.write((OWLPropertyExpression)oWLDataPropertyExpression);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseOWLDataPropertyNodeSetResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public boolean isAntiSymmetric(OWLObjectProperty oWLObjectProperty) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isAntiSymmetric");
            this.renderer.write((OWLPropertyExpression)oWLObjectProperty);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public boolean isFunctional(OWLDataProperty oWLDataProperty) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isFunctional");
            this.renderer.write((OWLPropertyExpression)oWLDataProperty);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public boolean isFunctional(OWLObjectProperty oWLObjectProperty) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isFunctional");
            this.renderer.write((OWLPropertyExpression)oWLObjectProperty);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public boolean isInverseFunctional(OWLObjectProperty oWLObjectProperty) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isInverseFunctional");
            this.renderer.write((OWLPropertyExpression)oWLObjectProperty);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public boolean isIrreflexive(OWLObjectProperty oWLObjectProperty) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isIrreflexive");
            this.renderer.write((OWLPropertyExpression)oWLObjectProperty);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public boolean isReflexive(OWLObjectProperty oWLObjectProperty) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isReflexive");
            this.renderer.write((OWLPropertyExpression)oWLObjectProperty);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public boolean isSymmetric(OWLObjectProperty oWLObjectProperty) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isSymmetric");
            this.renderer.write((OWLPropertyExpression)oWLObjectProperty);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public boolean isTransitive(OWLObjectProperty oWLObjectProperty) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isTransitive");
            this.renderer.write((OWLPropertyExpression)oWLObjectProperty);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual oWLNamedIndividual, boolean bl) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getTypes");
            this.renderer.write(oWLNamedIndividual);
            if (bl) {
                this.writeS("t");
            } else {
                this.writeS("nil");
            }
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseOWLClassNodeSetResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception.getCause());
        }
    }

    public boolean hasType(OWLIndividual oWLIndividual, OWLClassExpression oWLClassExpression, boolean bl) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-hasType");
            this.renderer.write(oWLIndividual.asOWLNamedIndividual());
            this.renderer.write(oWLClassExpression);
            if (bl) {
                this.writeS("t");
            } else {
                this.writeS("nil");
            }
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public NodeSet<OWLNamedIndividual> getIndividuals(OWLClassExpression oWLClassExpression, boolean bl) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getInstances");
            this.renderer.write(oWLClassExpression);
            if (bl) {
                this.writeS("t");
            } else {
                this.writeS("nil");
            }
            this.writeS(this.reasonerID);
            if (this.configuration.getIndividualNodeSetPolicy() == IndividualNodeSetPolicy.BY_NAME) {
                this.writeS("nil");
            } else {
                this.writeS("t");
            }
            this.writeCloseParln();
            return this.resultParser.parseOWLNamedIndividualNodeSetResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
        catch (Error error) {
            this.reportError(null);
            return null;
        }
    }

    public NodeSet<OWLNamedIndividual> getRelatedIndividuals(OWLNamedIndividual oWLNamedIndividual, OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getRelatedIndividuals");
            this.renderer.write(oWLNamedIndividual);
            this.renderer.write((OWLPropertyExpression)oWLObjectPropertyExpression);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            Node<OWLNamedIndividual> node = this.resultParser.parseOWLNamedIndividualNodeResult();
            OWLNamedIndividualNodeSet oWLNamedIndividualNodeSet = new OWLNamedIndividualNodeSet();
            switch (this.configuration.getIndividualNodeSetPolicy()) {
                case BY_NAME: {
                    oWLNamedIndividualNodeSet.addDifferentEntities(node.getEntities());
                    break;
                }
                case BY_SAME_AS: {
                    for (OWLNamedIndividual oWLNamedIndividual2 : node) {
                        oWLNamedIndividualNodeSet.addNode(this.getSameIndividuals(oWLNamedIndividual2));
                    }
                    break;
                }
            }
            return oWLNamedIndividualNodeSet;
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public NodeSet<OWLNamedIndividual> getRelatedIndividuals(OWLNamedIndividual oWLNamedIndividual, OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getRelatedIndividuals");
            this.renderer.write(oWLNamedIndividual);
            this.renderer.write((OWLPropertyExpression)oWLObjectPropertyExpression);
            if (bl) {
                this.writeS("t");
            } else {
                this.writeS("nil");
            }
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            Node<OWLNamedIndividual> node = this.resultParser.parseOWLNamedIndividualNodeResult();
            OWLNamedIndividualNodeSet oWLNamedIndividualNodeSet = new OWLNamedIndividualNodeSet();
            switch (this.configuration.getIndividualNodeSetPolicy()) {
                case BY_NAME: {
                    oWLNamedIndividualNodeSet.addDifferentEntities(node.getEntities());
                    break;
                }
                case BY_SAME_AS: {
                    for (OWLNamedIndividual oWLNamedIndividual2 : node) {
                        oWLNamedIndividualNodeSet.addNode(this.getSameIndividuals(oWLNamedIndividual2));
                    }
                    break;
                }
            }
            return oWLNamedIndividualNodeSet;
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual oWLNamedIndividual) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getSameIndividuals");
            this.renderer.write(oWLNamedIndividual);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            OWLNamedIndividualNode oWLNamedIndividualNode = (OWLNamedIndividualNode)this.resultParser.parseOWLNamedIndividualNodeResult();
            if (!oWLNamedIndividualNode.contains((OWLObject)oWLNamedIndividual)) {
                oWLNamedIndividualNode.add((OWLObject)oWLNamedIndividual);
            }
            return oWLNamedIndividualNode;
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public boolean isSameIndividual(OWLNamedIndividual oWLNamedIndividual, OWLNamedIndividual oWLNamedIndividual2) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isSameIndividual");
            this.renderer.write(oWLNamedIndividual);
            this.renderer.write(oWLNamedIndividual2);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual oWLNamedIndividual) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getDifferentIndividuals");
            this.renderer.write(oWLNamedIndividual);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            OWLNamedIndividualNode oWLNamedIndividualNode = (OWLNamedIndividualNode)this.resultParser.parseOWLNamedIndividualNodeResult();
            OWLNamedIndividualNodeSet oWLNamedIndividualNodeSet = new OWLNamedIndividualNodeSet();
            switch (this.configuration.getIndividualNodeSetPolicy()) {
                case BY_NAME: {
                    oWLNamedIndividualNodeSet.addDifferentEntities(oWLNamedIndividualNode.getEntities());
                    break;
                }
                case BY_SAME_AS: {
                    for (OWLNamedIndividual oWLNamedIndividual2 : oWLNamedIndividualNode) {
                        oWLNamedIndividualNodeSet.addNode(this.getSameIndividuals(oWLNamedIndividual2));
                    }
                    break;
                }
            }
            return oWLNamedIndividualNodeSet;
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public Map<OWLObjectProperty, Set<OWLIndividual>> getObjectPropertyRelationships(OWLNamedIndividual oWLNamedIndividual) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getObjectPropertyRelationships");
            this.renderer.write(oWLNamedIndividual);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseObjectPropertyFillerMapResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public boolean hasObjectPropertyRelationship(OWLIndividual oWLIndividual, OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLIndividual oWLIndividual2) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-hasObjectPropertyRelationship");
            this.renderer.write(oWLIndividual);
            this.renderer.write((OWLPropertyExpression)oWLObjectPropertyExpression);
            this.renderer.write(oWLIndividual2);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    public Set<OWLLiteral> getRelatedValues(OWLNamedIndividual oWLNamedIndividual, OWLDataPropertyExpression oWLDataPropertyExpression) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getRelatedValues");
            this.renderer.write(oWLNamedIndividual);
            this.renderer.write((OWLPropertyExpression)oWLDataPropertyExpression);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseConstantSetResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception.getCause());
        }
    }

    public final Map<OWLDataProperty, Set<OWLLiteral>> getDataPropertyRelationships(OWLNamedIndividual oWLNamedIndividual) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getDataPropertyRelationships");
            this.renderer.write(oWLNamedIndividual);
            this.writeS(this.reasonerID);
            this.writeCloseParln();
            return this.resultParser.parseDataPropertyValueMapResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception.getCause());
        }
    }

    public final NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual oWLNamedIndividual, OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getObjectPropertyValues");
            this.renderer.write(oWLNamedIndividual);
            this.renderer.write((OWLPropertyExpression)oWLObjectPropertyExpression);
            this.writeS(this.reasonerID);
            if (this.configuration.getIndividualNodeSetPolicy() == IndividualNodeSetPolicy.BY_NAME) {
                this.writeS("nil");
                this.writeCloseParln();
                return this.resultParser.parseOWLNamedIndividualNodeSetResult();
            }
            this.writeS("t");
            this.writeCloseParln();
            return this.resultParser.parseOWLNamedIndividualNodeSetResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return null;
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception.getCause());
        }
    }

    protected void handleChanges(Collection<OWLAxiom> collection, Collection<OWLAxiom> collection2) {
        if (collection.size() > 0) {
            this.autoBatchAddAxioms();
            this.isAdd = true;
            for (OWLAxiom oWLAxiom : collection) {
                oWLAxiom.accept((OWLAxiomVisitor)this.commandVisitor);
            }
            this.batchSynchronize();
        }
        if (collection2.size() > 0) {
            this.autoBatchRemoveAxioms();
            this.isAdd = false;
            for (OWLAxiom oWLAxiom : collection2) {
                oWLAxiom.accept((OWLAxiomVisitor)this.commandVisitor);
            }
            this.batchSynchronize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleChanges(Collection<OWLAxiom> collection, Collection<OWLAxiom> collection2, ReasonerProgressMonitor reasonerProgressMonitor) {
        int n = collection.size() + collection2.size();
        if (n > 0) {
            int n2 = 0;
            if (collection.size() > 0) {
                this.autoBatchAddAxioms();
                this.isAdd = true;
                for (OWLAxiom oWLAxiom : collection) {
                    if (this.isInterrupted) {
                        return;
                    }
                    oWLAxiom.accept((OWLAxiomVisitor)this.commandVisitor);
                    ++n2;
                }
                this.batchSynchronize();
            }
            if (collection2.size() > 0) {
                this.autoBatchRemoveAxioms();
                this.isAdd = false;
                for (OWLAxiom oWLAxiom : collection2) {
                    oWLAxiom.accept((OWLAxiomVisitor)this.commandVisitor);
                    ++n2;
                }
                this.batchSynchronize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleChanges_old(Collection<OWLAxiom> collection, Collection<OWLAxiom> collection2, ReasonerProgressMonitor reasonerProgressMonitor) {
        int n = collection.size() + collection2.size();
        if (n > 0) {
            try {
                reasonerProgressMonitor.reasonerTaskStarted("Update Reasoner Axioms...");
                int n2 = 0;
                if (collection.size() > 0) {
                    this.autoAddAxioms(this.ontologyID);
                    this.writeSequenceProlog();
                    this.isAdd = true;
                    for (OWLAxiom oWLAxiom : collection) {
                        oWLAxiom.accept((OWLAxiomVisitor)this);
                        reasonerProgressMonitor.reasonerTaskProgressChanged(++n2, n);
                    }
                    if (this.autoBatchSynchronizeNeeded) {
                        this.batchSynchronize();
                    }
                    this.writeSequenceEpilog();
                }
                if (collection2.size() > 0) {
                    this.autoRemoveAxioms(this.ontologyID, false);
                    this.writeSequenceProlog();
                    this.isAdd = false;
                    for (OWLAxiom oWLAxiom : collection2) {
                        oWLAxiom.accept((OWLAxiomVisitor)this);
                        reasonerProgressMonitor.reasonerTaskProgressChanged(++n2, n);
                    }
                    if (this.autoBatchSynchronizeNeeded) {
                        this.batchSynchronize();
                    }
                    this.writeSequenceEpilog();
                }
            }
            finally {
                reasonerProgressMonitor.reasonerTaskStopped();
            }
        }
    }

    public void applyChanges(List<OWLOntologyChange> list) {
    }

    protected final void applyChanges() {
    }

    public void visit(OWLSubClassOfAxiom oWLSubClassOfAxiom) {
        try {
            if (this.isAdd) {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-getOWLSubClassAxiom");
                this.renderer.write(oWLSubClassOfAxiom.getSubClass());
                this.renderer.write(oWLSubClassOfAxiom.getSuperClass());
                this.writeClosePar();
            } else {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-getOWLSubClassAxiom");
                this.renderer.write(oWLSubClassOfAxiom.getSubClass());
                this.renderer.write(oWLSubClassOfAxiom.getSuperClass());
                this.writeClosePar();
            }
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
        try {
            if (this.isAdd) {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-getOWLEquivalentClassesAxiom");
                this.writeSpace();
                this.writeOpenPar();
                for (OWLClassExpression oWLClassExpression : oWLEquivalentClassesAxiom.getClassExpressions()) {
                    this.renderer.write(oWLClassExpression);
                }
                this.writeClosePar();
                this.writeClosePar();
            } else {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-getOWLEquivalentClassesAxiom");
                this.writeSpace();
                this.writeOpenPar();
                for (OWLClassExpression oWLClassExpression : oWLEquivalentClassesAxiom.getClassExpressions()) {
                    this.renderer.write(oWLClassExpression);
                }
                this.writeClosePar();
                this.writeClosePar();
            }
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
        try {
            if (this.isAdd) {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-getOWLDisjointClassesAxiom");
                this.writeOpenPar();
                for (OWLClassExpression oWLClassExpression : oWLDisjointClassesAxiom.getClassExpressions()) {
                    this.renderer.write(oWLClassExpression);
                }
                this.writeClosePar();
                this.writeClosePar();
            } else {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-getOWLDisjointClassesAxiom");
                this.writeOpenPar();
                for (OWLClassExpression oWLClassExpression : oWLDisjointClassesAxiom.getClassExpressions()) {
                    this.renderer.write(oWLClassExpression);
                }
                this.writeClosePar();
                this.writeClosePar();
            }
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLDisjointUnionAxiom");
            this.renderer.write((OWLClassExpression)oWLDisjointUnionAxiom.getOWLClass());
            this.writeOpenPar();
            for (OWLClassExpression oWLClassExpression : oWLDisjointUnionAxiom.getClassExpressions()) {
                this.renderer.write(oWLClassExpression);
            }
            this.writeClosePar();
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom) {
        try {
            if (this.isAdd) {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-getOWLObjectSubPropertyAxiom");
                this.renderer.write(oWLSubObjectPropertyOfAxiom.getSubProperty());
                this.renderer.write(oWLSubObjectPropertyOfAxiom.getSuperProperty());
                this.writeClosePar();
            } else {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-getOWLObjectSubPropertyAxiom");
                this.renderer.write(oWLSubObjectPropertyOfAxiom.getSubProperty());
                this.renderer.write(oWLSubObjectPropertyOfAxiom.getSuperProperty());
                this.writeClosePar();
            }
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLEquivalentObjectPropertiesAxiom");
            this.writeOpenPar();
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLEquivalentObjectPropertiesAxiom.getProperties()) {
                this.renderer.write((OWLPropertyExpression)oWLObjectPropertyExpression);
            }
            this.writeClosePar();
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLObjectPropertyDomainAxiom");
            this.renderer.write(oWLObjectPropertyDomainAxiom.getProperty());
            this.renderer.write(oWLObjectPropertyDomainAxiom.getDomain());
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLTransitiveObjectPropertyAxiom");
            this.renderer.write(oWLTransitiveObjectPropertyAxiom.getProperty());
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLSymmetricObjectPropertyAxiom");
            this.renderer.write(oWLSymmetricObjectPropertyAxiom.getProperty());
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLInverseObjectPropertiesAxiom");
            this.renderer.write((OWLPropertyExpression)oWLInverseObjectPropertiesAxiom.getFirstProperty());
            this.renderer.write((OWLPropertyExpression)oWLInverseObjectPropertiesAxiom.getSecondProperty());
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLObjectPropertyRangeAxiom");
            this.renderer.write(oWLObjectPropertyRangeAxiom.getProperty());
            this.renderer.write((OWLClassExpression)oWLObjectPropertyRangeAxiom.getRange());
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom oWLAsymmetricObjectPropertyAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLAsymmetricObjectPropertyAxiom");
            this.renderer.write(oWLAsymmetricObjectPropertyAxiom.getProperty());
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLReflexiveObjectPropertyAxiom");
            this.renderer.write(oWLReflexiveObjectPropertyAxiom.getProperty());
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLDisjointObjectPropertiesAxiom");
            this.writeOpenPar();
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLDisjointObjectPropertiesAxiom.getProperties()) {
                this.renderer.write((OWLPropertyExpression)oWLObjectPropertyExpression);
            }
            this.writeClosePar();
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLFunctionalObjectPropertyAxiom");
            this.renderer.write(oWLFunctionalObjectPropertyAxiom.getProperty());
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLIrreflexiveObjectPropertyAxiom");
            this.renderer.write(oWLIrreflexiveObjectPropertyAxiom.getProperty());
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLInverseFunctionalObjectPropertyAxiom");
            this.renderer.write(oWLInverseFunctionalObjectPropertyAxiom.getProperty());
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLObjectPropertyChainSubPropertyAxiom");
            this.writeOpenPar();
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLSubPropertyChainOfAxiom.getPropertyChain()) {
                this.renderer.write((OWLPropertyExpression)oWLObjectPropertyExpression);
            }
            this.writeClosePar();
            this.renderer.write((OWLPropertyExpression)oWLSubPropertyChainOfAxiom.getSuperProperty());
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLSubDataPropertyOfAxiom oWLSubDataPropertyOfAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLDataSubPropertyAxiom");
            this.renderer.write(oWLSubDataPropertyOfAxiom.getSubProperty());
            this.renderer.write(oWLSubDataPropertyOfAxiom.getSuperProperty());
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLDataPropertyRangeAxiom");
            this.renderer.write(oWLDataPropertyRangeAxiom.getProperty());
            ((OWLDataRange)oWLDataPropertyRangeAxiom.getRange()).accept((OWLDataVisitor)this.renderer);
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLDataPropertyDomainAxiom");
            this.renderer.write(oWLDataPropertyDomainAxiom.getProperty());
            this.renderer.write(oWLDataPropertyDomainAxiom.getDomain());
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLDisjointDataPropertiesAxiom");
            this.writeOpenPar();
            for (OWLDataPropertyExpression oWLDataPropertyExpression : oWLDisjointDataPropertiesAxiom.getProperties()) {
                this.renderer.write((OWLPropertyExpression)oWLDataPropertyExpression);
            }
            this.writeClosePar();
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLFunctionalDataPropertyAxiom");
            this.renderer.write(oWLFunctionalDataPropertyAxiom.getProperty());
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLEquivalentDataPropertiesAxiom");
            this.writeOpenPar();
            for (OWLDataPropertyExpression oWLDataPropertyExpression : oWLEquivalentDataPropertiesAxiom.getProperties()) {
                this.renderer.write((OWLPropertyExpression)oWLDataPropertyExpression);
            }
            this.writeClosePar();
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLClassAssertionAxiom");
            this.renderer.write(oWLClassAssertionAxiom.getIndividual());
            this.renderer.write(oWLClassAssertionAxiom.getClassExpression());
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLObjectPropertyAssertionAxiom");
            this.renderer.write(oWLObjectPropertyAssertionAxiom.getSubject());
            this.renderer.write(oWLObjectPropertyAssertionAxiom.getProperty());
            this.renderer.write((OWLIndividual)oWLObjectPropertyAssertionAxiom.getObject());
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLNegativeObjectPropertyAssertionAxiom");
            this.renderer.write(oWLNegativeObjectPropertyAssertionAxiom.getSubject());
            this.renderer.write(oWLNegativeObjectPropertyAssertionAxiom.getProperty());
            this.renderer.write((OWLIndividual)oWLNegativeObjectPropertyAssertionAxiom.getObject());
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLSameIndividualsAxiom");
            this.writeOpenPar();
            for (OWLIndividual oWLIndividual : oWLSameIndividualAxiom.getIndividuals()) {
                this.renderer.write(oWLIndividual);
            }
            this.writeClosePar();
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLDifferentIndividualsAxiom");
            this.writeOpenPar();
            for (OWLIndividual oWLIndividual : oWLDifferentIndividualsAxiom.getIndividuals()) {
                this.renderer.write(oWLIndividual);
            }
            this.writeClosePar();
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLDataPropertyAssertionAxiom");
            this.renderer.write(oWLDataPropertyAssertionAxiom.getSubject());
            this.renderer.write(oWLDataPropertyAssertionAxiom.getProperty());
            ((OWLLiteral)oWLDataPropertyAssertionAxiom.getObject()).accept((OWLDataVisitor)this.renderer);
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-getOWLNegativeDataPropertyAssertionAxiom");
            this.renderer.write(oWLNegativeDataPropertyAssertionAxiom.getSubject());
            this.renderer.write(oWLNegativeDataPropertyAssertionAxiom.getProperty());
            ((OWLLiteral)oWLNegativeDataPropertyAssertionAxiom.getObject()).accept((OWLDataVisitor)this.renderer);
            this.writeClosePar();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public void visit(OWLDeclarationAxiom oWLDeclarationAxiom) {
        try {
            if (oWLDeclarationAxiom.getEntity() instanceof OWLObjectProperty) {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-getOWLImplicitDeclarationAxiom");
                this.writeSpace();
                this.writeOpenPar();
                this.writeKRSSMethodName("ObjectProperty");
                this.renderer.write((OWLPropertyExpression)((OWLObjectProperty)oWLDeclarationAxiom.getEntity()));
                this.writeClosePar();
                this.writeClosePar();
            } else if (oWLDeclarationAxiom.getEntity() instanceof OWLDataProperty) {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-getOWLImplicitDeclarationAxiom");
                this.writeSpace();
                this.writeOpenPar();
                this.writeKRSSMethodName("DataProperty");
                this.renderer.write((OWLPropertyExpression)((OWLDataProperty)oWLDeclarationAxiom.getEntity()));
                this.writeClosePar();
                this.writeClosePar();
            } else if (oWLDeclarationAxiom.getEntity() instanceof OWLClass) {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-getOWLImplicitDeclarationAxiom");
                this.writeSpace();
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLClass");
                this.renderer.write((OWLClassExpression)((OWLClass)oWLDeclarationAxiom.getEntity()));
                this.writeClosePar();
                this.writeClosePar();
            } else if (oWLDeclarationAxiom.getEntity() instanceof OWLIndividual) {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-getOWLImplicitDeclarationAxiom");
                this.writeSpace();
                this.writeOpenPar();
                this.writeKRSSMethodName("Individual");
                this.renderer.write((OWLIndividual)oWLDeclarationAxiom.getEntity());
                this.writeClosePar();
                this.writeClosePar();
            } else if (oWLDeclarationAxiom.getEntity() instanceof OWLAnnotationProperty) {
                this.writeOpenPar();
                this.writeKRSSMethodName("OWLAPI-getOWLImplicitDeclarationAxiom");
                this.writeSpace();
                this.writeOpenPar();
                this.writeKRSSMethodName("AnnotationProperty");
                this.renderer.write((OWLAnnotationProperty)oWLDeclarationAxiom.getEntity());
                this.writeClosePar();
                this.writeClosePar();
            }
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public boolean isEntailed(OWLAxiom oWLAxiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        try {
            this.writeOpenPar();
            this.writer.write("owlapi-is-entailed");
            this.writeSpace();
            oWLAxiom.accept((OWLAxiomVisitor)this);
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
    }

    public boolean isEntailed(Set<? extends OWLAxiom> set) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        for (OWLAxiom oWLAxiom : set) {
            if (this.isEntailed(oWLAxiom)) continue;
            return false;
        }
        return true;
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return this.entailmentChecker.isEntailmentCheckingSupported(axiomType);
    }

    public String sendNativeCommand(String string, boolean bl) {
        try {
            if (bl) {
                this.writeOpenPar();
                this.writer.print("in-knowledge-base");
                this.writeS(this.reasonerID);
                this.writeS(":init");
                this.writeS("nil");
                this.writeCloseParln();
                this.resultParser.readNativeLine();
            }
            this.writer.println(string);
            this.writer.flush();
            return this.resultParser.readNativeLine();
        }
        catch (Exception exception) {
            throw new RacerRuntimeException(exception);
        }
    }

    public boolean isConsistent() {
        try {
            this.writeOpenPar();
            this.writeKRSSMethodName("OWLAPI-isConsistent");
            this.writeS(this.ontologyID);
            this.writeS(this.reasonerID);
            if (!this.configuration.isAboxConsistencyTestEnabled()) {
                this.writeS("nil");
            }
            this.writeCloseParln();
            return this.resultParser.BooleanResult();
        }
        catch (ParseException parseException) {
            this.reportError(parseException);
            return false;
        }
    }

    private String readFromSocket2() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        char c = '\u0000';
        try {
            c = (char)this.inputStream.read();
            byteArrayOutputStream.write(c);
            while (true) {
                c = (char)this.inputStream.read();
                boolean bl = Character.isWhitespace(c);
                byteArrayOutputStream.write(c);
            }
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
    }

    private String readFromSocket() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n = this.inputStream.read();
            byteArrayOutputStream.write(n);
            while (n != 10) {
                n = this.inputStream.read();
                if (n == 10) continue;
                byteArrayOutputStream.write(n);
            }
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
        String string = byteArrayOutputStream.toString();
        return string;
    }

    public void reset() {
    }

    public final void setRangeDescriptions(boolean bl) {
        this.rangeDescriptions = bl;
    }

    public void reportError(ParseException parseException) {
        String string = this.sendNativeCommand("(OWLAPI-getLastAnswer)", false);
        string = this.sendNativeCommand("(OWLAPI-getLastAnswer)", false);
        throw new RacerRuntimeException(string, parseException);
    }

    public void shutdown() {
        this.writeOpenPar();
        this.writeKRSSMethodName("exit-server");
        this.writeCloseParln();
    }

    class SingleCommand
    implements OWLAxiomVisitor {
        Translator delegate;

        public SingleCommand() {
            this.delegate = Translator.this;
        }

        public void visit(OWLDeclarationAxiom oWLDeclarationAxiom) {
            OWLEntity oWLEntity = oWLDeclarationAxiom.getEntity();
            if (oWLEntity.isBuiltIn()) {
                return;
            }
            if (oWLEntity.isOWLClass() || oWLEntity.isOWLDataProperty() || oWLEntity.isOWLNamedIndividual() || oWLEntity.isOWLAnnotationProperty() || oWLEntity.isOWLObjectProperty()) {
                this.delegate.visit(oWLDeclarationAxiom);
                Translator.this.writeEpilog();
            }
        }

        public void visit(OWLSubClassOfAxiom oWLSubClassOfAxiom) {
            this.delegate.visit(oWLSubClassOfAxiom);
            Translator.this.writeEpilog();
        }

        public void writePrefix(String string, String string2) {
            Translator.this.writeOpenPar();
            Translator.this.writeKRSSMethodName("OWLAPI-addPrefix");
            Translator.this.writer.write(" ");
            Translator.this.writer.write("\"");
            Translator.this.writer.write(string);
            Translator.this.writer.write("\"");
            Translator.this.writer.write("\"");
            Translator.this.writer.write(string2);
            Translator.this.writer.write("\"");
            Translator.this.writeCloseParln();
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
            this.delegate.visit(oWLNegativeObjectPropertyAssertionAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom oWLAsymmetricObjectPropertyAxiom) {
            this.delegate.visit(oWLAsymmetricObjectPropertyAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom) {
            this.delegate.visit(oWLReflexiveObjectPropertyAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
            this.delegate.visit(oWLDisjointClassesAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom) {
            this.delegate.visit(oWLDataPropertyDomainAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom) {
            this.delegate.visit(oWLObjectPropertyDomainAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom) {
            this.delegate.visit(oWLEquivalentObjectPropertiesAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
            this.delegate.visit(oWLNegativeDataPropertyAssertionAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
            this.delegate.visit(oWLDifferentIndividualsAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom) {
            this.delegate.visit(oWLDisjointDataPropertiesAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom) {
            this.delegate.visit(oWLDisjointObjectPropertiesAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom) {
            this.delegate.visit(oWLObjectPropertyRangeAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
            this.delegate.visit(oWLObjectPropertyAssertionAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom) {
            this.delegate.visit(oWLFunctionalObjectPropertyAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom) {
            this.delegate.visit(oWLSubObjectPropertyOfAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
            this.delegate.visit(oWLDisjointUnionAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom) {
            this.delegate.visit(oWLSymmetricObjectPropertyAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom) {
            this.delegate.visit(oWLDataPropertyRangeAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom) {
            this.delegate.visit(oWLFunctionalDataPropertyAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom) {
            this.delegate.visit(oWLEquivalentDataPropertiesAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
            this.delegate.visit(oWLClassAssertionAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
            this.delegate.visit(oWLEquivalentClassesAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
            this.delegate.visit(oWLDataPropertyAssertionAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom) {
            this.delegate.visit(oWLTransitiveObjectPropertyAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom) {
            this.delegate.visit(oWLIrreflexiveObjectPropertyAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLSubDataPropertyOfAxiom oWLSubDataPropertyOfAxiom) {
            this.delegate.visit(oWLSubDataPropertyOfAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom) {
            this.delegate.visit(oWLInverseFunctionalObjectPropertyAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
            this.delegate.visit(oWLSameIndividualAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom) {
            this.delegate.visit(oWLSubPropertyChainOfAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom) {
            this.delegate.visit(oWLInverseObjectPropertiesAxiom);
            Translator.this.writeEpilog();
        }

        public void visit(OWLHasKeyAxiom oWLHasKeyAxiom) {
        }

        public void visit(OWLDatatypeDefinitionAxiom oWLDatatypeDefinitionAxiom) {
        }

        public void visit(SWRLRule sWRLRule) {
        }

        public void visit(OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom) {
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom) {
        }

        public void visit(OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom) {
        }

        public void visit(OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntailmentChecker
    implements OWLAxiomVisitorEx<Boolean> {
        Set<AxiomType> supportedAxiomsTypes = new HashSet<AxiomType>();

        public EntailmentChecker() {
            this.supportedAxiomsTypes.add(AxiomType.SUBCLASS_OF);
            this.supportedAxiomsTypes.add(AxiomType.ASYMMETRIC_OBJECT_PROPERTY);
            this.supportedAxiomsTypes.add(AxiomType.REFLEXIVE_OBJECT_PROPERTY);
            this.supportedAxiomsTypes.add(AxiomType.FUNCTIONAL_OBJECT_PROPERTY);
            this.supportedAxiomsTypes.add(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY);
            this.supportedAxiomsTypes.add(AxiomType.CLASS_ASSERTION);
            this.supportedAxiomsTypes.add(AxiomType.EQUIVALENT_CLASSES);
        }

        public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
            return this.supportedAxiomsTypes.contains(axiomType);
        }

        public Boolean visit(OWLSubClassOfAxiom oWLSubClassOfAxiom) {
            return Translator.this.isSubClassOf(oWLSubClassOfAxiom.getSubClass(), oWLSubClassOfAxiom.getSuperClass());
        }

        public Boolean visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLNegativeObjectPropertyAssertionAxiom);
        }

        public Boolean visit(OWLAsymmetricObjectPropertyAxiom oWLAsymmetricObjectPropertyAxiom) {
            return Translator.this.isAntiSymmetric(((OWLObjectPropertyExpression)oWLAsymmetricObjectPropertyAxiom.getProperty()).asOWLObjectProperty());
        }

        public Boolean visit(OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom) {
            return Translator.this.isReflexive(((OWLObjectPropertyExpression)oWLReflexiveObjectPropertyAxiom.getProperty()).asOWLObjectProperty());
        }

        public Boolean visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLDisjointClassesAxiom);
        }

        public Boolean visit(OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLDataPropertyDomainAxiom);
        }

        public Boolean visit(OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLObjectPropertyDomainAxiom);
        }

        public Boolean visit(OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLEquivalentObjectPropertiesAxiom);
        }

        public Boolean visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLNegativeDataPropertyAssertionAxiom);
        }

        public Boolean visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLDifferentIndividualsAxiom);
        }

        public Boolean visit(OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLDisjointDataPropertiesAxiom);
        }

        public Boolean visit(OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLDisjointObjectPropertiesAxiom);
        }

        public Boolean visit(OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLObjectPropertyRangeAxiom);
        }

        public Boolean visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
            return Translator.this.hasObjectPropertyRelationship(oWLObjectPropertyAssertionAxiom.getSubject(), (OWLObjectPropertyExpression)oWLObjectPropertyAssertionAxiom.getProperty(), (OWLIndividual)oWLObjectPropertyAssertionAxiom.getObject());
        }

        public Boolean visit(OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom) {
            return Translator.this.isFunctional(((OWLObjectPropertyExpression)oWLFunctionalObjectPropertyAxiom.getProperty()).asOWLObjectProperty());
        }

        public Boolean visit(OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLSubObjectPropertyOfAxiom);
        }

        public Boolean visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLDisjointUnionAxiom);
        }

        public Boolean visit(OWLDeclarationAxiom oWLDeclarationAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLDeclarationAxiom);
        }

        public Boolean visit(OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLAnnotationAssertionAxiom);
        }

        public Boolean visit(OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom) {
            return Translator.this.isSymmetric(((OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty()).asOWLObjectProperty());
        }

        public Boolean visit(OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLDataPropertyRangeAxiom);
        }

        public Boolean visit(OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom) {
            return Translator.this.isFunctional(((OWLDataPropertyExpression)oWLFunctionalDataPropertyAxiom.getProperty()).asOWLDataProperty());
        }

        public Boolean visit(OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLEquivalentDataPropertiesAxiom);
        }

        public Boolean visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
            return Translator.this.hasType(oWLClassAssertionAxiom.getIndividual(), oWLClassAssertionAxiom.getClassExpression(), false);
        }

        public Boolean visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
            Vector vector = new Vector();
            vector.addAll(oWLEquivalentClassesAxiom.getClassExpressions());
            for (int i = 0; i < vector.size(); ++i) {
                for (int j = i; j < vector.size(); ++j) {
                    if (Translator.this.isEquivalentClass((OWLClassExpression)vector.get(i), (OWLClassExpression)vector.get(j))) continue;
                    return false;
                }
            }
            return true;
        }

        public Boolean visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLDataPropertyAssertionAxiom);
        }

        public Boolean visit(OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom) {
            return Translator.this.isTransitive(((OWLObjectPropertyExpression)oWLTransitiveObjectPropertyAxiom.getProperty()).asOWLObjectProperty());
        }

        public Boolean visit(OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom) {
            return Translator.this.isIrreflexive(((OWLObjectPropertyExpression)oWLIrreflexiveObjectPropertyAxiom.getProperty()).asOWLObjectProperty());
        }

        public Boolean visit(OWLSubDataPropertyOfAxiom oWLSubDataPropertyOfAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLSubDataPropertyOfAxiom);
        }

        public Boolean visit(OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLInverseFunctionalObjectPropertyAxiom);
        }

        public Boolean visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLSameIndividualAxiom);
        }

        public Boolean visit(OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLSubPropertyChainOfAxiom);
        }

        public Boolean visit(OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLInverseObjectPropertiesAxiom);
        }

        public Boolean visit(OWLHasKeyAxiom oWLHasKeyAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLHasKeyAxiom);
        }

        public Boolean visit(OWLDatatypeDefinitionAxiom oWLDatatypeDefinitionAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLDatatypeDefinitionAxiom);
        }

        public Boolean visit(SWRLRule sWRLRule) {
            return false;
        }

        public Boolean visit(OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLSubAnnotationPropertyOfAxiom);
        }

        public Boolean visit(OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLAnnotationPropertyDomainAxiom);
        }

        public Boolean visit(OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom) {
            throw new UnsupportedEntailmentTypeException((OWLAxiom)oWLAnnotationPropertyRangeAxiom);
        }
    }

    protected class NamedObjectForAnnotationRenderer
    implements OWLNamedObjectVisitor {
        ShortFormProvider shortFormProvider;
        Writer writer;

        public NamedObjectForAnnotationRenderer(Writer writer, ShortFormProvider shortFormProvider) {
            this.writer = writer;
            this.shortFormProvider = shortFormProvider;
        }

        public final void visit(OWLClass oWLClass) {
            try {
                Translator.this.writeSpace();
                this.writer.write("(");
                this.writer.write("OWLClass");
                Translator.this.writeSpace();
                this.writer.write(this.shortFormProvider.shortForm(oWLClass.getIRI()));
                this.writer.write(")");
            }
            catch (IOException iOException) {
                throw new RacerRuntimeException(iOException);
            }
        }

        public final void visit(OWLObjectProperty oWLObjectProperty) {
            try {
                Translator.this.writeSpace();
                this.writer.write("(");
                this.writer.write("ObjectProperty");
                Translator.this.writeSpace();
                this.writer.write(this.shortFormProvider.shortForm(oWLObjectProperty.getIRI()));
                this.writer.write(")");
            }
            catch (IOException iOException) {
                throw new RacerRuntimeException(iOException);
            }
        }

        public final void visit(OWLDataProperty oWLDataProperty) {
            try {
                Translator.this.writeSpace();
                this.writer.write("(");
                this.writer.write("DataProperty");
                Translator.this.writeSpace();
                this.writer.write(this.shortFormProvider.shortForm(oWLDataProperty.getIRI()));
                this.writer.write(")");
            }
            catch (IOException iOException) {
                throw new RacerRuntimeException(iOException);
            }
        }

        public final void visit(OWLIndividual oWLIndividual) {
            try {
                this.writer.write("(");
                this.writer.write("Individual");
                Translator.this.writeSpace();
                if (oWLIndividual.isAnonymous()) {
                    this.writer.write(oWLIndividual.asOWLAnonymousIndividual().getID().toString());
                } else {
                    this.writer.write(this.shortFormProvider.shortForm(oWLIndividual.asOWLNamedIndividual().getIRI()));
                }
                this.writer.write(")");
            }
            catch (IOException iOException) {
                throw new RacerRuntimeException(iOException);
            }
        }

        public void visit(OWLAnnotationProperty oWLAnnotationProperty) {
        }

        public void visit(OWLNamedIndividual oWLNamedIndividual) {
            try {
                this.writer.write("(");
                this.writer.write("Individual");
                Translator.this.writeSpace();
                this.writer.write(this.shortFormProvider.shortForm(oWLNamedIndividual.asOWLNamedIndividual().getIRI()));
                this.writer.write(")");
            }
            catch (IOException iOException) {
                throw new RacerRuntimeException(iOException);
            }
        }

        public void visit(OWLOntology oWLOntology) {
        }

        public void visit(OWLDatatype oWLDatatype) {
        }
    }

    class BuiltInEntityDeclaration
    extends RuntimeException {
        OWLEntity entity;

        public BuiltInEntityDeclaration(OWLEntity oWLEntity) {
            this.entity = oWLEntity;
        }

        public OWLEntity getEntity() {
            return this.entity;
        }
    }
}

