/*
 * Decompiled with CFR 0.152.
 */
package com.racersystems.racer.util;

import com.racersystems.racer.util.ShortFormProvider;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;

public class RacerShortFormProvider
implements ShortFormProvider {
    private final OWLDataFactory factory;
    private final IRI top;
    private final IRI bottom;
    private final IRI bottomObjectProperty;
    private final IRI bottomDataProperty;
    private final IRI topObjectProperty;
    private final IRI topDataProperty;

    public RacerShortFormProvider(OWLDataFactory oWLDataFactory) {
        this.factory = oWLDataFactory;
        this.top = oWLDataFactory.getOWLThing().getIRI();
        this.bottom = oWLDataFactory.getOWLNothing().getIRI();
        this.bottomObjectProperty = oWLDataFactory.getOWLBottomObjectProperty().getIRI();
        this.bottomDataProperty = oWLDataFactory.getOWLBottomDataProperty().getIRI();
        this.topObjectProperty = oWLDataFactory.getOWLTopObjectProperty().getIRI();
        this.topDataProperty = oWLDataFactory.getOWLTopDataProperty().getIRI();
    }

    public final String getShortForm(OWLEntity oWLEntity) {
        return this.shortForm(oWLEntity.getIRI());
    }

    public final String shortForm(IRI iRI) {
        if (iRI.equals(this.top)) {
            return "top";
        }
        if (iRI.equals(this.bottom)) {
            return "bottom";
        }
        if (iRI.equals(this.bottomDataProperty)) {
            return "bottom-datatype-role";
        }
        if (iRI.equals(this.bottomObjectProperty)) {
            return "bottom-object-role";
        }
        if (iRI.equals(this.topObjectProperty)) {
            return "top-object-role";
        }
        if (iRI.equals(this.topDataProperty)) {
            return "top-datatype-role";
        }
        return '|' + iRI.toString() + '|';
    }

    public final IRI longForm(String string) {
        if (string == "top") {
            return this.factory.getOWLThing().getIRI();
        }
        if (string == "bottom") {
            return this.factory.getOWLNothing().getIRI();
        }
        if (string == "bottom-datatype-role") {
            return this.bottomDataProperty;
        }
        if (string == "bottom-object-role") {
            return this.bottomObjectProperty;
        }
        if (string == "top-datatype-role") {
            return this.topDataProperty;
        }
        if (string == "top-object-role") {
            return this.topObjectProperty;
        }
        string = string.replaceAll("|", "");
        return IRI.create((String)string);
    }
}

